function getLabelType(index) {
    switch (index) {
        case 'policia':
            return ['fa-solid fa-location-dot', 'police']
        case 'negado':
            return ['fa-regular fa-circle-xmark', 'denied']
        case 'aviso':
            return ['fa-solid fa-triangle-exclamation', 'warning']
        case 'anuncio':
            return ['fa-solid fa-bullhorn', 'anuncio']
        default:
            return ['fa-regular fa-circle-check', 'success']
    }
}

function createNotify(type, title, message, time) {
	let pos = Math.floor(Math.random() * 1000 + 1);

    let setup = getLabelType(type.toLowerCase());

	$("notifySide").append(`
        <div class="index-${pos} notify ${setup[1]}">
            <i class="fa-regular ${setup[0]}"></i>
            <nav class="text">
                <h1>${title}</h1>
                <p>${message}</p>
            </nav>
            <div class="progress">
                <div class="value" style="animation: load ${time / 1000}s normal forwards"></div>
            </div>
        </div>
    `);

	anime({
		targets: `.index-${pos}`,
		translateX: 420,
		duration: 750,
		easing: "spring(1, 80, 100, 0)",
	});

	setTimeout(function () {
		anime({
			targets: `.index-${pos}`,
			translateX: -420,
			duration: 750,
			easing: "spring(1, 80, 100, 0)",
		});
		setTimeout(function () {
			$(`.index-${pos}`).remove();
		}, 750);
	}, time);
}

let firstTimer, lastTimer, isDisplayed = false;
function createAnnounce(title, message, author, time) {
	if (isDisplayed) {
		isDisplayed = false;

        clearTimeout(firstTimer);
		clearTimeout(lastTimer);

        $(`.announce`).remove();

		createAnnounce(title, message, author, time);
		return;
	}

	isDisplayed = true;

    let setup = getLabelType('anuncio');

	$("announces").html(`
        <div class="announce">
            <nav class="content">
                <i class="${setup[0]}"></i>
                <article>
                    <h1>${title}</h1>
                    <p>${message}</p>
                    <footer>
                        <p class="prefix">Enviado por:</p>
                        <p class="sender">${author}</p>
                    </footer>
                </article>
            </nav>
            <div class="progress">
                <div class="value" style="animation: slider ${time / 1000}s normal forwards"></div>
            </div>
        </div>
    `);

	anime({
		targets: `.announce`,
		translateX: -620,
		duration: 750,
		easing: "spring(1, 80, 100, 0)",
	});

	firstTimer = setTimeout(function () {
		anime({
			targets: `.announce`,
			translateX: 620,
			duration: 750,
            easing: "spring(1, 80, 100, 0)",
		});
		lastTimer = setTimeout(function () {
			isDisplayed = false;
			$(`.announce`).remove();
		}, 400);
	}, time);
}

const itemLabel = (type) => type.toLowerCase() == 'recebido' ? 'recived' : 'removed';
const itemSignal = (type) => type.toLowerCase() == 'recebido' ? '+' : '-';

const pathImg = './images';
function createItemNotify(type, index, name, amount) {
	let pos = Math.floor(Math.random() * 1000 + 1);

	$("notifyItems").append(`
        <div class="item-${pos} item ${itemLabel(type)}" style="background-image: url('${pathImg}/${index}.png')">
            <p class="index removed">${itemSignal(type)}${amount}</p>
            <p class="title">${name}</p>
        </div>
    `);

	anime({
		targets: `.item-${pos}`,
		translateY: -400,
		duration: 750,
		easing: "spring(1, 80, 100, 0)",
	});

	setTimeout(function () {
		anime({
			targets: `.item-${pos}`,
			translateY: 400,
			duration: 750,
			easing: "spring(1, 80, 100, 0)",
		});
		setTimeout(function () {
			$(`.item-${pos}`).remove();
		}, 750);
	}, 6 * 1000);
}

function deleteAnnounce() {
	if (isDisplayed) {
		isDisplayed = false;

        clearTimeout(firstTimer);
		clearTimeout(lastTimer);

        $(`.announce`).remove();
	}
}